function [dof, logL]=EstimateTCanonicalVine(data,optimizer)
%%%-----------Canonical T - Copula Vine likelihood Estimation-----------
% This function estimates the parameters of a Canonical vine assuming that
% all pairs follow a (static) T-Copula
% INPUTS:
% data:             A TxN matrix of U(0,1) or iid margins
% optimizer:        String with values 'fmincon' (default) or 'fminunc'

display('if you want to calculate st. errors run EstimTCanonicalVine.m instead')

if nargin==1
   optimizer='fmincon';
end
if min(min(data))<0 || max(max(data))>1
    data=empiricalCDF(data);
end
tic
N=size(data,2);
lik=ones(N-1,N-1);
u=cell(N,N);
dof=ones(N-1,N-1);

for j=1:N-1
   fprintf(1,'computing copula parameters for level %d\n',j)
   for i=1:N-j
      if j==1
      [dof(j,i),lik(j,i)]=EstimateStaticTCopula([data(:,1),data(:,i+1)],optimizer);
      else
      [dof(j,i),lik(j,i)]=EstimateStaticTCopula([u{j-1,1},u{j-1,i+1}],optimizer);
      end
   end
   
   if j<N-1
       for i=1:N-j
       if j==1
       rho=corr([data(:,1) data(:,i+1)],'type','Kendall'); 
       rho=sin(.5*pi*rho(1,2));
       u{j,i}=hfuncTC(data(:,i+1),data(:,1),dof(j,i),rho);    
       else    
       rho=corr([u{j-1,i+1} u{j-1,1}],'type','Kendall'); 
       rho=sin(.5*pi*rho(1,2));
       u{j,i}=hfuncTC(u{j-1,i+1},u{j-1,1},dof(j,i),rho);
       end
       end
   end
end
logL=sum(sum(lik));
toc
